/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "GetInputDeviceCapabilitiesCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"
#include "RendererList.h"
#include "InputManager.h"

ExecutionResult GetInputDeviceCapabilitiesCommand::execute(ICommandExecutor* executor)
{
    ExecutionResult result = ExecutionSuccess;

    RendererList* rList;
    RendererListConstIterator it;

    rList = executor->getRendererList();
    for (it = rList->begin(); (it != rList->end()) && (result == ExecutionSuccess); it++)
    {
        InputManager* pInputManager = (*it)->getInputManager((char*)m_pSeatName);
        if (NULL != pInputManager)
        {
            result = pInputManager->getCurrentDevices(m_pBitmask) ? ExecutionSuccess : ExecutionFailed;
        }
        else
        {
            std::string seatName(m_pSeatName);
            result = ExecutionFailed;
            LOG_ERROR("GetInputDeviceCapabilitiesCommand", "obtained NULL input manager for seat :" << seatName);
        }
    }
    return result;
}

const std::string GetInputDeviceCapabilitiesCommand::getString()
{
    std::stringstream description;
    std::string seatName(m_pSeatName);
    description << "GetInputDeviceCapabilitiesCommand("
                << "seat_name=" << seatName
                << "bitmask=" << *m_pBitmask
                << ")";
    return description.str();
}
